\version "2.18.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  %top-system-spacing #'basic-distance = #10
  %score-system-spacing #'basic-distance = #20
  %system-system-spacing #'basic-distance = #20
  %last-bottom-spacing #'basic-distance = #10

  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 0\mm
  bottom-margin = 0\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Joy to the world"
  %subtitle = "Adeste fideles"
  %subsubtitle = "Nr. 9, Choral"
  %poet = "F.H.Ranke (1798-1876)"
  %composer = "(Christmas)"
  %arranger =  "arr. W.H.Monk(1823-1886)"
  %meter = "Andante"
  tagline = ""
}

global = {
  #(set-global-staff-size 18.5)
  \key d \major
  \time 2/2
  %\partial 4
  %\override Staff.TimeSignature.stencil = ##f
  %\set Timing.defaultBarType = ""
  %\set Score.barNumberVisibility = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}


sopWordsOne = \lyricmode {
  \skip 1 \skip 1  \skip 1 \skip 1
  the Lord is come!
  Let earth re -- ceive her King! __  
}

altWordsOne = \lyricmode {
  "1. Joy" to the world, the Lord, the Lord is come!
  Let earth re -- ceive her King, re -- ceive her King!
  Let ev -- 'ry heart pre -- pare Him room,
  And heav'n and na -- ture sing,
  and heav'n and na -- ture sing,
  and heav'n and  heav'n and na -- ture sing! sing!
}  

altWordsTwo = \lyricmode {
  "2. Joy" to the earth, the Sa -- vior, Sa -- vior reigns:
  Let men their songs em -- ploy, their songs em -- ploy!
  While fields and floods, rocks, hills and plains
  Re -- peat the soun -- ding joy,
  re -- peat the soun -- ding joy,
  re -- peat, re -- peat the soun -- ding joy. joy.
}

altWordsFour = \lyricmode {
  "4. He" rules the world with truth, with truth and grace,
  And makes the na -- tions prove, the na -- tions prove, 
  The glo -- ries of His right -- eous -- ness,
  And won -- ders of His love,
  and won -- ders of His love,
  and won -- ders, won -- ders of His love. love.
}


tenorWordsOne = \lyricmode {
  \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1
  \skip 1
  Let earth
}

bassWordsOne = \lyricmode {
  "1. Joy" to the world, the Lord is come!
  Let earth re -- ceive her King,  re -- ceive her King,
  Let ev -- 'ry heart pre -- pare Him room,
  And heav'n and na -- ture sing,
  and heav'n and na -- ture sing, 
  and heav'n and na -- ture sing! sing!
}

bassWordsTwo = \lyricmode {
  "2. Joy" to the earth, the Sa -- vior reigns:
  Let men their songs em -- ploy, their songs em -- ploy! 
  While fields and floods, rocks, hills and plains
  Re -- peat the soun -- ding joy,
  re -- peat the soun -- ding joy, 
  re -- peat the soun -- ding joy! joy!
}

bassWordsFour = \lyricmode {
  "4. He" rules the world with truth and grace,
  And makes the na -- tions prove, the na -- tions prove, 
 The glo -- ries of His right -- eous -- ness,
  And won -- ders of His love,
  and won -- ders of His love,
  and won -- ders of His love. love.  
}

sopMusic = \relative c'' {
  d2 cis4. h8 a2. 
  g4^\markup with ^\markup the ^\markup the 
  fis2  ^\markup truth  ^\markup "Sa   - " ^\markup Lord 
  e  ^\markup and ^\markup vior ^\markup is
  d2.  ^\markup grace, ^\markup reigns! ^\markup come!
  a'4  ^\markup and ^\markup Let ^\markup Let
  h2.  ^\markup "makes             the      na      -       tions    prove" 
  ^\markup "men                their    songs          em   -  ploy" 
  ^\markup "earth              re   -   ceive            her      King"
  h4  cis2.  cis4 d1( d2.) d4 ^\markup [SOLI]
  d4( cis) h( a) a4.( g8 fis4) d' d( cis) h( a) a4.( g8 fis4) \fermata
  \repeat volta 2 {
   fis4 ^\markup [FULL]
   fis fis fis fis a2. g8([ fis]) e4 e e e g2. fis8([ e])
   d4( d'2) h4 a4.( g8 fis4) g fis2 e   
  }
  \alternative {
   { d2. s4 }
   { d1 }
  }
  \bar"|."
}

altMusic = \relative c'' {
  fis,2 e4. e8 a,4( d2) d4 a4 d d cis d2. fis4
  g4 d g2( g4) e a2( a8) fis([ g a]) h4 h a2. fis4
  fis4( a) g2 fis4.( e8 d4) fis4 fis( a) g2 fis4.( e8 d4)
  \repeat volta 2 {
   d4 d d d d d2. d4 d d cis cis cis2. cis4
   d2( a'4) g fis4.( e8 d4) d d2 cis
  }
  \alternative {
   { d2. s4 }
   { d1}
  }
}

tenorMusic = \relative c' {
  a2 g8([ a]) h([ cis]) d4.( e8 fis4)
  h,8([ cis]) d4 fis,8([ g]) a4 e fis a d2(
  d4) h e2( e4) cis fis2( fis4) d g g fis2. a,4
  a4.( fis8) g8([ a h cis]) d2. a4 a8([ fis g a]) h([ cis d e]) d4.( e8 fis4) \fermata
  \repeat volta 2 {
   d,4\rest d2\rest d4\rest a'4 a a a a a2. a4 g g g g 
   a4.( g8 fis4) d' d( a2) g4 a2. a4
  } 
  \alternative {
   { fis2. s4 }
   { fis1}
  }
}

bassMusic = \relative c {
  d2 e4. e8 fis4.( e8 d4) h a2 a d2. d4
  g2. e4 a2. fis4 h4. a8 g([ a]) h([ cis]) d2. d,4
  d2 d d2. d4 fis8[( d e fis]) g([ a h cis]) d2.
  \repeat volta 2 {
   d,4\rest d2\rest d4\rest d4 fis fis fis fis a2. g8([ fis]) e4 e e e
   fis4.( e8 d4) d d2. h4 a2 a
  } 
  \alternative {
   { d2. s4 }
   { d1 }
  } 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics \altWordsOne
      \addlyrics \altWordsTwo
      \addlyrics \altWordsFour
     >>

    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \bassWordsOne }
      \addlyrics { \bassWordsTwo }
      \addlyrics { \bassWordsFour }
    >>
  >>
>>


\score {
   \myScore
   \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}